/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : gpio.c
* Author             : MCD Application Team
* Date First Issued  : 06/08/2003
* Description        : C Library retargeting for the 1780 AN.
********************************************************************************
* History:
*  01/01/2004 : V1.2
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#include <stdio.h>
#include <time.h>
#include "71x_lib.h"

#define USE_LCD

#ifdef USE_LCD
  #include "lcd.h"
#endif

#pragma import(__use_no_semihosting_swi)
//#pragma import (__use_two_region_memory)


struct __FILE { int handle;   /* Add whatever you need here */};
FILE __stdout;
FILE __stdin;

void sendchar(char *ch);    /* in serial.c */
char receive_char(void);    /* in serial.c */

int last_char_read;
int backspace_called;

int fputc(int ch, FILE *f)
{
 char tempch = ch;

#ifdef USE_LCD
  LCD_sendchar(tempch);
#endif

#ifdef USE_SERIAL_PORT
 sendchar( &tempch );
#endif

 return ch;
}

int fgetc(FILE *f)
{
    unsigned char tempch;
    /* if we just backspaced, then return the backspaced character */
    /* otherwise output the next character in the stream */
    if (backspace_called == TRUE)
    {
      backspace_called = FALSE;
      return last_char_read;
    }

    tempch = receive_char();
    last_char_read = (int)tempch;       /* backspace must return this value */
    return tempch;
}


int ferror(FILE *f)
{   /* Your implementation of ferror */
    return EOF;
}

/*
** The effect of __backspace() should be to return the last character
** read from the stream, such that a subsequent fgetc() will
** return the same character again.
*/

int __backspace(FILE *f)
{
    backspace_called = TRUE;
    return 1;
}


void _sys_exit(int return_code)
{
    while(1);
}


void _ttywrch(int ch)
{
    char tempch = ch;
    sendchar( &tempch );
}

__value_in_regs struct R0_R3 {unsigned heap_base, stack_base, heap_limit, stack_limit;}
    __user_initial_stackheap(unsigned int R0, unsigned int SP, unsigned int R2, unsigned int SL)
{
    struct R0_R3 config;

    config.heap_base  = 0x2000A000;
    config.stack_base = 0x20010000;

    return config;
}


#ifdef USE_SERIAL_PORT

void sendchar(char *ch)
{
char *c;
  UART_ByteSend(UARTX,ch);
 if(*ch=='\n')
{
  *c='\r';
  UART_ByteSend(UARTX,c);
}
}

char receive_char(void)
{
  volatile char ch = '0';

   while (!(UARTX->SR&(UART_RxHalfFull|UART_RxBufFull)));// wait until we receive a byte
   ch = (u8)UARTX->RxBUFR; // receive character
  return ch;
}
#endif

